package org.openqa.selenium.devtools.v119.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired once when parsing the .wbn file has succeeded.
 * The event contains the information about the web bundle contents.
 */
@org.openqa.selenium.Beta()
public class SubresourceWebBundleMetadataReceived {

    private final org.openqa.selenium.devtools.v119.network.model.RequestId requestId;

    private final java.util.List<java.lang.String> urls;

    public SubresourceWebBundleMetadataReceived(org.openqa.selenium.devtools.v119.network.model.RequestId requestId, java.util.List<java.lang.String> urls) {
        this.requestId = java.util.Objects.requireNonNull(requestId, "requestId is required");
        this.urls = java.util.Objects.requireNonNull(urls, "urls is required");
    }

    /**
     * Request identifier. Used to match this information to another event.
     */
    public org.openqa.selenium.devtools.v119.network.model.RequestId getRequestId() {
        return requestId;
    }

    /**
     * A list of URLs of resources in the subresource Web Bundle.
     */
    public java.util.List<java.lang.String> getUrls() {
        return urls;
    }

    private static SubresourceWebBundleMetadataReceived fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v119.network.model.RequestId requestId = null;
        java.util.List<java.lang.String> urls = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "requestId":
                    requestId = input.read(org.openqa.selenium.devtools.v119.network.model.RequestId.class);
                    break;
                case "urls":
                    urls = input.readArray(java.lang.String.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SubresourceWebBundleMetadataReceived(requestId, urls);
    }
}
