package org.openqa.selenium.devtools.v119.performancetimeline;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * Reporting of performance timeline events, as specified in
 * https://w3c.github.io/performance-timeline/#dom-performanceobserver.
 */
@Beta()
public class PerformanceTimeline {

    /**
     * Previously buffered events would be reported before method returns.
     * See also: timelineEventAdded
     */
    public static Command<Void> enable(java.util.List<java.lang.String> eventTypes) {
        java.util.Objects.requireNonNull(eventTypes, "eventTypes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventTypes", eventTypes);
        return new Command<>("PerformanceTimeline.enable", Map.copyOf(params));
    }

    public static Event<org.openqa.selenium.devtools.v119.performancetimeline.model.TimelineEvent> timelineEventAdded() {
        return new Event<>("PerformanceTimeline.timelineEventAdded", ConverterFunctions.map("event", org.openqa.selenium.devtools.v119.performancetimeline.model.TimelineEvent.class));
    }
}
