/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.devtools.CdpInfo;
import org.openqa.selenium.devtools.CdpVersionFinder;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.noop.NoOpCdpInfo;
import org.openqa.selenium.firefox.AddHasContext;
import org.openqa.selenium.firefox.AddHasExtensions;
import org.openqa.selenium.firefox.AddHasFullPageScreenshot;
import org.openqa.selenium.firefox.FirefoxCommandContext;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.HasContext;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.firefox.HasFullPageScreenshot;
import org.openqa.selenium.html5.LocalStorage;
import org.openqa.selenium.html5.SessionStorage;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.manager.SeleniumManagerOutput;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.html5.RemoteWebStorage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverFinder;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements WebStorage,
HasExtensions,
HasFullPageScreenshot,
HasContext,
HasDevTools,
HasBiDi {
    private static final Logger LOG = Logger.getLogger(FirefoxDriver.class.getName());
    private final Capabilities capabilities;
    private final RemoteWebStorage webStorage = new RemoteWebStorage(this.getExecuteMethod());
    private final HasExtensions extensions = new AddHasExtensions().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasFullPageScreenshot fullPageScreenshot = new AddHasFullPageScreenshot().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final HasContext context = new AddHasContext().getImplementation(this.getCapabilities(), this.getExecuteMethod());
    private final Optional<URI> cdpUri;
    private final Optional<URI> biDiUri;
    private org.openqa.selenium.devtools.Connection connection;
    private DevTools devTools;
    private Optional<BiDi> biDi;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(GeckoDriverService.createDefaultService(), options);
    }

    public FirefoxDriver(FirefoxDriverService service) {
        this(service, new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options) {
        this(service, options, ClientConfig.defaultConfig());
    }

    public FirefoxDriver(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        this(FirefoxDriver.generateExecutor(service, options, clientConfig), options);
    }

    private static FirefoxDriverCommandExecutor generateExecutor(FirefoxDriverService service, FirefoxOptions options, ClientConfig clientConfig) {
        Require.nonNull((String)"Driver service", (Object)((Object)service));
        Require.nonNull((String)"Driver options", (Object)((Object)options));
        Require.nonNull((String)"Driver clientConfig", (Object)clientConfig);
        if (service.getExecutable() == null) {
            SeleniumManagerOutput.Result result = DriverFinder.getPath((DriverService)service, (Capabilities)options);
            service.setExecutable(result.getDriverPath());
            if (result.getBrowserPath() != null && !result.getBrowserPath().isEmpty()) {
                options.setBinary(result.getBrowserPath());
            }
        }
        return new FirefoxDriverCommandExecutor(service, clientConfig);
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options) {
        this(executor, options, ClientConfig.defaultConfig());
    }

    private FirefoxDriver(FirefoxDriverCommandExecutor executor, FirefoxOptions options, ClientConfig clientConfig) {
        super((CommandExecutor)executor, FirefoxDriver.checkCapabilitiesAndProxy((Capabilities)options));
        Optional<ImmutableCapabilities> cdpUri;
        Capabilities capabilities = super.getCapabilities();
        HttpClient.Factory factory = HttpClient.Factory.createDefault();
        Optional reportedUri = CdpEndpointFinder.getReportedUri((String)"moz:debuggerAddress", (Capabilities)capabilities);
        Optional<HttpClient> client = reportedUri.map(uri -> CdpEndpointFinder.getHttpClient((HttpClient.Factory)factory, (URI)uri));
        try {
            cdpUri = client.flatMap(httpClient -> CdpEndpointFinder.getCdpEndPoint((HttpClient)httpClient));
        }
        catch (Exception e) {
            try {
                client.ifPresent(HttpClient::close);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
        try {
            client.ifPresent(HttpClient::close);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "failed to close the http client used to check the reported CDP endpoint: " + reportedUri.get(), e);
        }
        Optional<String> webSocketUrl = Optional.ofNullable((String)capabilities.getCapability("webSocketUrl"));
        this.biDiUri = webSocketUrl.map(uri -> {
            try {
                return new URI((String)uri);
            }
            catch (URISyntaxException e) {
                LOG.warning(e.getMessage());
                return null;
            }
        });
        this.biDi = this.createBiDi(this.biDiUri);
        this.cdpUri = cdpUri;
        this.capabilities = (Capabilities)cdpUri.map(uri -> new ImmutableCapabilities((Capabilities)new PersistentCapabilities(capabilities).setCapability("se:cdp", (Object)uri.toString()).setCapability("se:cdpVersion", (Object)"85.0"))).orElse(new ImmutableCapabilities(capabilities));
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return RemoteWebDriver.builder().oneOf((Capabilities)new FirefoxOptions(), new Capabilities[0]);
    }

    private static Capabilities checkCapabilitiesAndProxy(Capabilities capabilities) {
        if (capabilities == null) {
            return new ImmutableCapabilities();
        }
        MutableCapabilities caps = new MutableCapabilities(capabilities);
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public LocalStorage getLocalStorage() {
        return this.webStorage.getLocalStorage();
    }

    public SessionStorage getSessionStorage() {
        return this.webStorage.getSessionStorage();
    }

    @Override
    public String installExtension(Path path) {
        Require.nonNull((String)"Path", (Object)path);
        return this.extensions.installExtension(path);
    }

    @Override
    public String installExtension(Path path, Boolean temporary) {
        Require.nonNull((String)"Path", (Object)path);
        Require.nonNull((String)"Temporary", (Object)temporary);
        return this.extensions.installExtension(path, temporary);
    }

    @Override
    public void uninstallExtension(String extensionId) {
        Require.nonNull((String)"Extension ID", (Object)extensionId);
        this.extensions.uninstallExtension(extensionId);
    }

    @Override
    public <X> X getFullPageScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Require.nonNull((String)"OutputType", outputType);
        return this.fullPageScreenshot.getFullPageScreenshotAs(outputType);
    }

    @Override
    public FirefoxCommandContext getContext() {
        return this.context.getContext();
    }

    @Override
    public void setContext(FirefoxCommandContext commandContext) {
        Require.nonNull((String)"Firefox Command Context", (Object)((Object)commandContext));
        this.context.setContext(commandContext);
    }

    @Deprecated
    public Optional<DevTools> maybeGetDevTools() {
        if (this.devTools != null) {
            return Optional.of(this.devTools);
        }
        if (!this.cdpUri.isPresent()) {
            return Optional.empty();
        }
        URI wsUri = this.cdpUri.orElseThrow(() -> new DevToolsException("This version of Firefox or geckodriver does not support CDP"));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        this.connection = new org.openqa.selenium.devtools.Connection(wsClient, wsUri.toString());
        CdpInfo cdpInfo = new CdpVersionFinder().match("85.0").orElseGet(NoOpCdpInfo::new);
        this.devTools = new DevTools(arg_0 -> ((CdpInfo)cdpInfo).getDomains(arg_0), this.connection);
        return Optional.of(this.devTools);
    }

    @Deprecated
    public DevTools getDevTools() {
        if (!this.cdpUri.isPresent()) {
            throw new DevToolsException("This version of Firefox or geckodriver does not support CDP");
        }
        return this.maybeGetDevTools().orElseThrow(() -> new DevToolsException("Unable to initialize CDP connection"));
    }

    private Optional<BiDi> createBiDi(Optional<URI> biDiUri) {
        if (!biDiUri.isPresent()) {
            return Optional.empty();
        }
        URI wsUri = biDiUri.orElseThrow(() -> new BiDiException("This version of Firefox or geckodriver does not support BiDi"));
        HttpClient.Factory clientFactory = HttpClient.Factory.createDefault();
        ClientConfig wsConfig = ClientConfig.defaultConfig().baseUri(wsUri);
        HttpClient wsClient = clientFactory.createClient(wsConfig);
        Connection biDiConnection = new Connection(wsClient, wsUri.toString());
        return Optional.of(new BiDi(biDiConnection));
    }

    public Optional<BiDi> maybeGetBiDi() {
        return this.biDi;
    }

    public BiDi getBiDi() {
        if (!this.biDiUri.isPresent()) {
            throw new BiDiException("This version of Firefox or geckodriver does not support Bidi");
        }
        return this.maybeGetBiDi().orElseThrow(() -> new BiDiException("Unable to initialize Bidi connection"));
    }

    public void quit() {
        super.quit();
    }

    private static class FirefoxDriverCommandExecutor
    extends DriverCommandExecutor {
        public FirefoxDriverCommandExecutor(DriverService service) {
            this(service, ClientConfig.defaultConfig());
        }

        public FirefoxDriverCommandExecutor(DriverService service, ClientConfig clientConfig) {
            super(service, FirefoxDriverCommandExecutor.getExtraCommands(), clientConfig);
        }

        private static Map<String, CommandInfo> getExtraCommands() {
            return Stream.of(new AddHasContext().getAdditionalCommands(), new AddHasExtensions().getAdditionalCommands(), new AddHasFullPageScreenshot().getAdditionalCommands()).flatMap(m -> m.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
    }
}

